/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.screen.animator.dialog;

import java.util.List;
import java.util.stream.Collectors;
import lib.toma.animations.api.AnimationStage;
import lib.toma.animations.api.lifecycle.Registries;
import lib.toma.animations.engine.screen.animator.AnimatorScreen;
import lib.toma.animations.engine.screen.animator.dialog.DialogScreen;
import lib.toma.animations.engine.screen.animator.widget.MultiSelectListView;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CopyFrameDialog
extends DialogScreen {
    private final ICopyCallback copyCallback;
    private final AnimationStage selectedStage;
    private MultiSelectListView<AnimationStage> selector;
    private boolean selected;

    public CopyFrameDialog(AnimatorScreen screen, ICopyCallback callback, AnimationStage selected) {
        super((ITextComponent)new TranslationTextComponent("screen.animator.dialog.copy_frame"), screen);
        this.copyCallback = callback;
        this.selectedStage = selected;
        this.setDimensions(150, 120);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        int btnWidthP = this.dWidth() - 10;
        int btnWidth = (btnWidthP - 5) / 2;
        List list = Registries.ANIMATION_STAGES.values().stream().filter(stage -> !stage.equals(this.selectedStage)).collect(Collectors.toList());
        this.selector = (MultiSelectListView)this.func_230480_a_(new MultiSelectListView(this.field_230712_o_, this.left() + 5, this.top() + 15, btnWidthP, 75, list));
        this.selector.setSelectionResponder(this::selection_change);
        this.selector.setFormatter(stage -> stage.getName().getString());
        this.cancel = (Button)this.func_230480_a_((Widget)new Button(this.left() + 5, this.top() + 95, btnWidth, 20, CANCEL, this::cancel_clicked));
        this.confirm = (Button)this.func_230480_a_((Widget)new Button(this.left() + 10 + btnWidth, this.top() + 95, btnWidth, 20, CONFIRM, this::confirm_clicked));
        this.updateConfirmButton();
    }

    @Override
    public boolean func_231177_au__() {
        return true;
    }

    private void selection_change(AnimationStage stage, List<AnimationStage> selection) {
        this.selected = !selection.isEmpty();
        this.updateConfirmButton();
    }

    private void confirm_clicked(Button button) {
        if (this.copyCallback != null) {
            this.copyCallback.onCopied(this.selector.getSelection());
        }
        this.showParent();
    }

    private void updateConfirmButton() {
        if (this.confirm != null) {
            this.confirm.field_230693_o_ = this.selected;
        }
    }

    public static interface ICopyCallback {
        public void onCopied(List<AnimationStage> var1);
    }
}

